<?php

// Decode URL
function base64UrlDecode($string)
{
    if (is_null($string)) {
        return null;
    }

    return base64_decode(str_replace(['-','_'], ['+','/'], $string));
}

// Display all error, for easy troubleshooting
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Something like https://track.com?t=xxxxxx
$encodedTrackingUrl = $_GET['t'] ?? null;

if (is_null($encodedTrackingUrl)) {
    // Get the actual url (old way). Something like: https://track.com/xxxxxx ==> get 'xxxxxx'
    // Capture the URI and return OK
    $uri = parse_url($_SERVER['REQUEST_URI']);
    $encodedTrackingUrl = trim($uri['path'], '/');
}

// Test endpoint
if ($encodedTrackingUrl == 'ok') {
    echo "ok";
    exit();
}

if (empty($encodedTrackingUrl)) {
    echo "Tracking domain is ready";
    exit();
}

// Redirect
if (isset($_GET['debug'])) {
    echo "Before decoded: {$trackingUrl}";
}

$trackingUrl = base64UrlDecode($encodedTrackingUrl);

if (isset($_GET['debug'])) {
    echo "<br>After decoded: {$trackingUrl}";
    exit();
}

header("Location: {$trackingUrl}");
